﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;

namespace UDPClientExample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btSend_Click(object sender, EventArgs e)
        {
            //Getting the user information
            string host = tbHost.Text;
            IPAddress[] addresses = Dns.GetHostAddresses(host);
            int port = int.Parse(tbPort.Text);
            byte[] comment = Encoding.ASCII.GetBytes(tbComment.Text);

            //Setting the local/remote Socket Endpoints
            IPEndPoint local = new IPEndPoint(IPAddress.Any, 9999);
            IPEndPoint remote = new IPEndPoint(addresses[0], port);
            
            //Create the UDP Socket
            UdpClient udpc = new UdpClient(local);

            //Connect to the remote computer
            udpc.Connect(remote);

            //Send the users comment
            udpc.Send(comment, comment.Length);

            //get and display the servers response
            byte[] response = udpc.Receive(ref remote);
            tbReply.Text = Encoding.ASCII.GetString(response);
            udpc.Close();
        }

    }
}
