﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;
using System.Reflection;

namespace SocketSample
{
    public partial class fmServerSocket : Form
    {

        int _ServerPort = 8181;
        static String res = "hello world HTTP/1.1 200 OK\r\n\r\nHello World!\r\n";
        byte[] msg = Encoding.ASCII.GetBytes(res);

        public fmServerSocket()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Threading.Thread t = new System.Threading.Thread(this.SimpleServe);
            t.Start();
        }

        private void SimpleServe()
        {
            int count = 1;
            tbMessage.Text = "";
            TcpListener listener = new TcpListener(IPAddress.Any, _ServerPort);
            listener.Start();
            //The listener is started and we now ready to start accepting 
            //connections on the port specified. When a person attempts to 
            //connect, we need to create a new Socket (TcpCLient) to talk to 
            //that incoming connection. 

            while (true)
            {
                //This statement will block - waiting for an incoming connection
                using (TcpClient cli = listener.AcceptTcpClient())
                {
                    //Some one connected... lets see what they have to say...
                    //We always send data as a stream of bytes, so we create a Stream catch 
                    //those incoming bytes and a buffer to store them in.
                    NetworkStream ns = cli.GetStream();
                    byte[] buffer = new byte[100000];
                    try
                    {
                        //wait till data is available - believe it or not, our computer is 
                        //faster than the internet. This is a timing hack!
                        while (!ns.DataAvailable)
                        {
                            ; //spinning...
                        }

                        //read up to 80 bytes from the stream and find out how many actually arrived
                        Int32 k = 0;
                        while (ns.DataAvailable && (k = ns.Read(buffer, 0, buffer.Length)) != 0)
                        {
                            SetControlPropertyValue(tbBytesRead, "Text", count.ToString());
                            SetControlPropertyValue(tbMessage, "Text", Encoding.ASCII.GetString(buffer, 0, k));
                        }
                        msg = Encoding.ASCII.GetBytes((String)(res + "count = " + count.ToString()));
                        ns.Write(msg, 0, msg.Length);
                        count++;

                        cli.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                        break;
                    }
                }
            }
            listener.Stop();

        }

        //IGNORE BELOW THIS IS A THREADED APP SO THAT YOU CAN SEE THE RESULTS IN THE MAIN WINDOW

        delegate void SetControlValueCallback(Control oControl, string propName, object propValue);

        private void SetControlPropertyValue(Control oControl, string propName, object propValue)
        {
            if (oControl.InvokeRequired)
            {
                SetControlValueCallback d = new SetControlValueCallback(SetControlPropertyValue);
                oControl.Invoke(d, new object[] { oControl, propName, propValue });
            }
            else
            {
                Type t = oControl.GetType();
                PropertyInfo[] props = t.GetProperties();
                foreach (PropertyInfo p in props)
                {
                    if (p.Name.ToUpper() == propName.ToUpper())
                    {
                        p.SetValue(oControl, propValue, null);
                    }
                }
            }
        }


    }
}
