﻿using System;
using System.Collections;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace ChatServer
{
    class Program
    {
        public static Hashtable ClientList = new Hashtable();

        static void Main()
        {
            var serverSocket = new TcpListener(IPAddress.Any, 8888);
            serverSocket.Start();
            Console.WriteLine("Chat server started...");
            while (true)
            {
                //This next line of code actually blocks
                TcpClient clientSocket = serverSocket.AcceptTcpClient();
                //Somebody connected and set us data
                string dataFromClient = GetStringFromStream(clientSocket);
                ClientList.Add(dataFromClient, clientSocket);
                Broadcast(dataFromClient + " joined.", dataFromClient, false);
                Console.WriteLine(dataFromClient + " joined cat room.");
                var client = new HandleClient();
                client.StartClient(clientSocket, dataFromClient);
            }
        }

        public static void Broadcast(string msg, string uname, bool flag)
        {
            foreach (DictionaryEntry item in ClientList)
            {
                var broadcastSocket = (TcpClient)item.Value;
                NetworkStream broadcastStream = broadcastSocket.GetStream();
                byte[] broadcastBytes = flag ? Encoding.ASCII.GetBytes(uname + " says: " + msg)
                    : Encoding.ASCII.GetBytes(msg);
                broadcastStream.Write(broadcastBytes, 0, broadcastBytes.Length);
                broadcastStream.Flush();
            }
        }

        public static string GetStringFromStream(TcpClient clientSocket)
        {
            var bytesFrom = new byte[16384];
            NetworkStream networkStream = clientSocket.GetStream();
            networkStream.Read(bytesFrom, 0, 16384);
            string dataFromClient = Encoding.ASCII.GetString(bytesFrom);
            return dataFromClient.Substring(0, dataFromClient.IndexOf("$", StringComparison.Ordinal));
        }
    }
}
