﻿using System;
using System.Net.Sockets;
using System.Threading;

namespace ChatServer
{
    public class HandleClient
    {
        private TcpClient _clientSocket;
        private string _clientNumber;

        public void StartClient(TcpClient clientSocket, string clientNumber)
        {
            _clientNumber = clientNumber;
            _clientSocket = clientSocket;
            var thread = new Thread(DoChat);
            thread.Start();
        }

        private void DoChat()
        {
            int requestCount = 0;
            while (true)
            {
                try
                {
                    requestCount += 1;
                    string dataFromClient = Program.GetStringFromStream(_clientSocket); 
                    Console.WriteLine("From Client - " + _clientNumber + ": " + dataFromClient);
                    Program.Broadcast(dataFromClient, _clientNumber, true);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }
    }
}
