﻿using System.ComponentModel;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace ChatClient.Models
{
    class ClientModel : INotifyPropertyChanged
    {
        private TcpClient _socket;
        private NetworkStream _stream;

        private string _messageBoard;
        public string MessageBoard {
            get { return _messageBoard; }
            set 
            {
                _messageBoard = value;
                NotifyPropertyChanged("MessageBoard");
            }
        }
        
        private string _currentMessage;
        public string CurrentMessage 
        {
            get {return _currentMessage;}
            set 
            {
                _currentMessage = value;
                NotifyPropertyChanged("CurrentMessage");
            }
        }
        
        private bool _connected;
        public bool Connected
        {
            get { return _connected; }
            set
            {
                _connected = value;
                NotifyPropertyChanged("Connected");
            }
        }

        /// <summary>
        /// Simple Constructor
        /// </summary>
        public ClientModel()
        {
            _connected = false;
        }

        public void Connect()
        {
            _socket = new TcpClient();
            _socket.Connect("127.0.0.1", 8888);
            _stream = _socket.GetStream();
            Connected = true;
            Send();
            _messageBoard = "Welcome: " + _currentMessage;
            var thread = new Thread(GetMessage);
            thread.Start();
        }

        public void Send()
        {
            WriteString(_currentMessage + "$");
        }

        private void GetMessage()
        {
            while (true)
            {
                string msg = ReadString();
                MessageBoard += "\r\n" + msg;
            }
        }

        private string ReadString()
        {
            var bytes = new byte[65536];
            _stream.Read(bytes, 0, _socket.ReceiveBufferSize);
            string msg = Encoding.ASCII.GetString(bytes);
            int index = msg.IndexOf("$") > 0 ? msg.IndexOf("$")
                : msg.IndexOf('\0');
            return msg.Substring(0, index);

        }

        private void WriteString(string msg)
        {
            byte[] bytes = Encoding.ASCII.GetBytes(msg);
            _stream.Write(bytes, 0, bytes.Length);
            _stream.Flush();
        }


        #region NPC
        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(string prop)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(prop));
            }
        }
        #endregion
    }
}
