﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TextBookDataModel;

namespace Demo
{
    class Demo1
    {
        private static ACMTextBookEntities _context;

        static void Main(string[] args)
        {
            //Create a new Entity Framework Context
            _context = new ACMTextBookEntities();
            //Populate context with student "Dean Martin"
            Student Dean = _context.Students.Where(x=>x.FirstName.Equals("Dean")).First();
            Professor Nolan = _context.Professors.Where(x => x.FirstName.Equals("Nolan")).First();
            Professor Hank = _context.Professors.Where(x => x.FirstName.Equals("Hank")).First();

            Console.WriteLine("Dean has " + Dean.Professors.First().FullName + " as an advisor. With ID: " + Dean.Professors.First().ProfessorID);
            List<Professor> current = Dean.Professors.ToList();
            current[0] = Hank;
            Console.WriteLine("Dean has " + Dean.Professors.First().FullName + " as an advisor. With ID: " + Dean.Professors.First().ProfessorID);
            //No Change yet
            _context.SaveChanges();
            Console.WriteLine("Dean has " + Dean.Professors.First().FullName + " as an advisor. With ID: " + Dean.Professors.First().ProfessorID);
            //Still no change [Expected right?]

            Dean.Professors.Remove(Nolan);
            Dean.Professors.Add(Hank);
            Console.WriteLine("Dean has " + Dean.Professors.First().FullName + " as an advisor. With ID: " + Dean.Professors.First().ProfessorID);

            //Wouldn't it be a lot easier just to change the PrfessorID? Since 
            //we have a list of Professors, we can't just go change the ID 
            //because we don't have access an object representing the intersection!

            //Now let's consider an Association table. 
            Console.WriteLine("Dean is now in " + Dean.ClassRosters.First().ClassSectionName + ".");
            ClassRoster csr = Dean.ClassRosters.Where(x => x.StudentID == Dean.StudentID).First();

            //Move Dean Martin to Section B (SectionID = 2)
            //Here we do have access to the ID's so we should be able to just change that!
            try
            {
                csr.SectionID = 2;
            }
            catch (Exception e)
            {
                Console.WriteLine("*** ERROR: " + e.Message + " ***");
            }

            // instead we'll have to actually remove the item from the list
            // and add a new one back in.

            Dean.ClassRosters.Remove(csr);
            Dean.ClassRosters.Add(new ClassRoster() {SectionID = 2});
            Console.WriteLine("Dean is now in " + Dean.ClassRosters.First().ClassSectionName + ".");

            _context.SaveChanges();

        }
    }
}
